<?php

namespace App\Http\Controllers\customAuth;

use App\sms;
use App\User;
use Illuminate\Http\Request;

class forgetPasswordController extends Controller
{
    public function step1()
    {
        if (!(session('verifyMobile') && session('verifyMobile')['expire'] > now())) {
            session()->forget('forgetpassword');
            message('خطا', 'زمان ریست پسورد شما به پایان رسیده است', 'error');
            return redirect()->route('auth.step1');
        }

        $sms = sms::where('mobile', session('verifyMobile')['mobile'])->where('created_at', '>', now()->subMinute(1))->latest()->first();
        if (isset($sms->id)) {
            message('خطا', 'شما یکبار در دقیقه فقط یکبار میتوانید درخواست ارسال کنید', 'error');
            return redirect()->route('auth.login');
        }

        $code = random_int(9999, 99999);
        sms::create(['mobile' => session('verifyMobile')['mobile'], 'body' => $code]);

        if (session('forgetpassword')) {
            if (session('forgetpassword')['expire'] > now()) {
                kavenegar($code, session('verifyMobile')['mobile']);
                session(['forgetpassword' => [
                    'code' => $code,
                    'count' => 1 + session('forgetpassword')['count'],
                    'expire' => now()->addMinute(1)
                ]]);
            }
            session(['forgetpassword' => [
                'code' => $code,
                'count' => 1 + session('forgetpassword')['count'],
                'expire' => session('forgetpassword')['expire'],
            ]]);
        } else {
            session(['forgetpassword' => [
                'code' => $code,
                'count' => 1,
                'expire' => now()->addMinute(1)
            ]]);
            kavenegar($code, session('verifyMobile')['mobile']);
        }


        return view('customAuth.passwords.step1');
    }

    public function step1Post(Request $request)
    {
        if ($request->input('code') != session('forgetpassword')['code']) {
            return redirect()->route('auth.forgetpassword')->withErrors(['notCredentials' => 'کد وارد شده صحیح نیست'])->withInput();
        }


//        message('پسورد شما ریست شد','لطفا رمز خود را عوض کنید رمز ارسالی یکبار مصرف میباشد.','success',false);
//        auth()->loginUsingId($user->id);

        return redirect()->route('auth.forgetpassword.step2');
    }


    public function step2(Request $request)
    {
        if (!(session('verifyMobile') && session('verifyMobile')['expire'] > now())) {
            session()->forget('forgetpassword');
            message('خطا','زمان ریست پسورد شما به پایان رسیده است','error');
            return redirect()->route('auth.step1');
        }

        return view('customAuth.passwords.step2');
    }

    public function step2Post(Request $request)
    {
        if (!(session('verifyMobile') && session('verifyMobile')['expire'] > now())) {
            session()->forget('forgetpassword');
            message('خطا','زمان ریست پسورد شما به پایان رسیده است','error');
            return redirect()->route('auth.step1');
        }

        $this->validate($request,[
            'password' => 'required|string|min:6|max:256|confirmed',
        ]);

        $user = User::where('mobile',session('verifyMobile')['mobile'])->where('userName',session('verifyMobile')['userName'])->first();
        session()->forget('verifyMobile');
        $user->update(['password'=>bcrypt($request->input('password'))]);
        auth()->loginUsingId($user->id);
        return redirect()->route('user.home');
    }


    public function step3()
    {

    }

    public function step3Post(Request $request)
    {

    }


    public function forgetpasswordSmsCode()
    {
        $sms = sms::where('mobile', session('verifyMobile')['mobile'])->where('created_at', '>', now()->subMinute(1))->latest()->first();
        if (isset($sms->id)) {
            message('خطا','شما یکبار در دقیقه فقط یکبار میتوانید درخواست ارسال کنید','error');
            return redirect()->route('auth.forgetpassword');
        }

        message('کد با موفقیت ارسال شد','کد با موفقیت ارسال شد');
        return redirect()->route('auth.forgetpassword');
    }
}
