<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Service\serviceCardStatus;
use App\Models\Service\serviceCategory;
use App\Models\Service\serviceDepartment;
use App\Models\Service\serviceOffer;

class panelController extends Controller
{
    public function index()
    {
        $organization = auth()->user()->organization()->first();

        $departments = serviceDepartment::validate()->with('category')->get();

        $offerDiscounts = serviceOffer::validate()->where('type', 'offer')->get();

        $allCategires = serviceCategory::validate()->whereHas('offer', function ($query) {
            $query->where('type', '<>', 'offer');
        })->with('offer')->get();


        $serviceCardStatusUser = auth()->user()->serviceCardStatus;
        $serviceCardStatus = serviceCardStatus::validate()->get();
        $isPay = auth()->user()->serviceCard()->count();


        return view('user.panel',compact('departments','offerDiscounts','allCategires','serviceCardStatus','serviceCardStatusUser','organization','isPay'));
    }
}
