<?php

namespace App\Http\Controllers\User\Order;

use App\Http\Controllers\Controller;
use App\Libraries\Classes\gateway\Kipo;
use App\Models\Order\transaction;
use Illuminate\Http\Request;
use kipolaboratory\KipoPay\KipoKPG;

class paymentController extends Controller
{
    public function verify($pin,Request $request)
    {
        $transaction = transaction::where('status', 'pending')->where('pin', $pin)->firstOrFail();


        $result = Kipo::getInstance()->verify();
        if ($result['status'] == 'success') {
            message();
            auth()->user()->serviceCard()->attach([$transaction->order->orderItem[0]->model_id]);
            auth()->user()->update([
                'isPay' => 1,
                'canEdit' => 1
            ]);

            auth()->user()->referalOrganizion()->attach([auth()->user()->ref]);
            $transaction->update(['status' => 'success', 'refNumber' => $result['code']]);
            $transaction->order->update(['status' => 'success', 'payStatus' => 'success', 'payRefNumber' => $result['code']]);
        } else {
            message('خطا', 'پرداخت شما با خطا مواجه شد', 'error');
            $transaction->update(['status' => 'error']);
            $transaction->order->update(['status' => 'error', 'payStatus' => 'error']);
        }


        return redirect()->route('user.home');
    }
}
