<?php

namespace App\Http\Controllers\User\Order;

use App\Http\Controllers\Controller;
use App\Libraries\Classes\gateway\Kipo;
use App\Models\Order\order;
use App\Models\Order\transaction;
use App\Models\Service\serviceCard;
use Illuminate\Http\Request;
use Jenssegers\Agent\Agent;
use kipolaboratory\KipoPay\KipoKPG;

class orderController extends Controller
{
    public function serviceCardPay()
    {
        $serviceCard = serviceCard::first();
        $agent = new Agent();
        $order = order::create([
            'user_id' => auth()->user()->id,
            'payCode' => auth()->user()->id,
            'payType' => 'online',
            'payStatus' => 'pending',
            'price' => $serviceCard->price,
            'currency' => 'toman',
            'type' => 'online',
            'status' => 'pending',
        ]);
        $order->orderItem()->create([
            'model_type' => 'App\Models\Service',
            'model_id' => $serviceCard->id,
            'title' => $serviceCard->title,
            'qty' => 1,
            'unitPrice' => $serviceCard->price,
            'finalPrice' => $serviceCard->price,
            'type' => 'online',
            'status' => 'pending'
        ]);

        $order->transaction()->create([
            'user_id' => auth()->user()->id,
            'gateway_id' => 1,
            'gatewayType' => 'kipo',
            'pin' => bin2hex(openssl_random_pseudo_bytes(32)),
            'device' => $agent->device(),
            'ip' => request()->ip(),
            'browser' => $agent->browser(),
            'browserVersion' => $agent->version($agent->browser()),
            'os' => $agent->platform(),
            'osVersion' => $agent->version($agent->platform()),
            'price' => $serviceCard->price,
            'statusGateway' => 'pending',
            'status' => 'pending'
        ]);
        Kipo::getInstance()->send($order);
    }
}
