<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Libraries\Rules\nationalCode;
use App\Models\Service\serviceCardStatus;
use App\Models\User\userMobileVerify;
use App\User;
use Illuminate\Http\Request;

class inquiryServiceCardController extends Controller
{
    public function show(Request $request)
    {
        $type = '';
        if ($request->input('type') == 'agencies') {
            $type = 'نمایندگی';
        } elseif ($request->input('type') == 'schools') {
            $type = 'باشگاههای ورزشی';
        } elseif ($request->input('type') == 'specialists') {
            $type = 'آموزش های فنی و حرفهای';
        } elseif ($request->input('type') == 'languageEducation') {
            $type = ' آموزشگاههای زبان';
        } elseif ($request->input('type') == 'freeEducation') {
            $type = 'آموزشگاههای علمی آزاد';
        } elseif ($request->input('type') == 'members') {
            $type = 'اعضا';
        } else {
            $type = 'وضعیت کارت';
        }

        return view('front.inqueryServiceCard.show', compact('type'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'mobile' => 'required|numeric|digits_between:10,11',
            'nationalCode' => [
                'required',
                new nationalCode(),
            ],
        ]);

        $user = User::where('mobile', $request->input('mobile'))->where('nationalCode', $request->input('nationalCode'))->first();
        if (isset($user->id)) {
            $serviceCardStatusUser = $user->serviceCardStatus;
            $serviceCardStatus = serviceCardStatus::validate()->get();

            return view('front.inqueryServiceCard.show', compact('serviceCardStatusUser', 'serviceCardStatus'));
        } else {
            message('خطا', 'مشخصات وارد شده در سیستم موجود نمیباشد', 'error');
            return redirect()->route('front.inquiry.cervicecard.show');
        }
        return redirect()->to('/');
    }
}
