<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Service\serviceOffer;
use App\Models\User\userMobileVerify;
use Jenssegers\Agent\Agent;

class ServiceClickController extends Controller
{
    public function click($id)
    {
        $serviceoffer = serviceOffer::validate()->findOrFail($id);
        $agent = new Agent();

        $serviceoffer->click()->create([
            'device' => $agent->device(),
            'ip' => request()->ip(),
            'browser' => $agent->browser(),
            'browserVersion' => $agent->version($agent->browser()),
            'os' => $agent->platform(),
            'osVersion' => $agent->version($agent->platform()),
        ]);
        $serviceoffer->increment('clicks');

        return redirect()->to($serviceoffer->link);
    }
}
