<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Region\city;
use App\Models\Region\state;
use App\Models\Service\serviceDepartment;
use App\Models\User\userMobileVerify;
use Illuminate\Support\Facades\Cache;

class HomeController extends Controller
{
    public function index()
    {
        if (!cache('home_serviceDepartments')) {
            $serviceDepartments = serviceDepartment::with(['category' => function ($query) {
                $query->select('service_categories.id', 'service_categories.title', 'service_categories.picture')->validate()->with(['offer' => function ($query) {
                    $query->validate();
                }]);
            }])->limit(2)->get();

            Cache::put('home_serviceDepartments', $serviceDepartments, 600);
        } else {
            $serviceDepartments = cache()->get('home_serviceDepartments');
        }


        if (!cache('home_statesService')) {
            $statesBuy = state::validate()->has('city.user.referalOrganizion')->get();

            $states = state::validate()->get();
            $statesService = new \stdClass();
            foreach ($states as $state) {
                if ($statesBuy->where('id', $state->id)->first()) {
                    $id = $state->id;
                    $statesService->$id = 1;
                } else {
                    $id = $state->id;
                    $statesService->$id = 0;
                }
            }

            $statesService2 = new \stdClass();
            foreach ($states as $state) {
                if ($statesBuy->where('id', $state->id)->first()) {
                    $id = $state->mapCode();
                    $statesService2->$id = (object)[
                        'name' => $state->title,
                        'color' => "#10711e",
                    ];
                } else {
                    $id = $state->mapCode();
                    $statesService2->$id = (object)[
                        'name' => $state->title,
                    ];
                }
            }

            cache()->put('statesService', $statesService, 600);
            cache()->put('statesService2', $statesService2, 600);
        } else {
            $statesService = cache('statesService');
            $statesService2 = cache('statesService2');
        }


        return view('front.home.index',compact('serviceDepartments','statesService','statesService2'));
    }

    public function referalCode($code)
    {

        $ref = referalCode($code);
        if (!$ref['status']) {
            abort(404);
        }

        session(['refCode' => $code]);

        return redirect()->route('auth.register.create');
    }

    public function expire()
    {
        return view('front.home.expire');
    }
}
