<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Libraries\Classes\gateway\Kipo;
use App\Models\formBuilder\formBuilder;
use App\Models\Hall\hall;
use App\Models\Hall\reservation;
use App\Models\Hall\sessionTime;
use App\Models\Order\order;
use App\Models\Service\serviceCard;
use App\Models\Service\serviceCategory;
use App\Models\Service\serviceDepartment;
use App\Models\Service\serviceOffer;
use App\Models\Ticket\ticket;
use App\User;
use Jenssegers\Agent\Agent;
use kipolaboratory\KipoPay\KipoKPG;


class panelController extends Controller
{
    public function index()
    {
        $data['userChart'] = User::where('isAdmin', 0)->where('created_at', '>=', now()->subMonth(48))->selectRaw('DATE_FORMAT(created_at,"%Y-%m-%d") as day,count(id) as user_count')->groupBy('day')->get();
        $data['userServiceCardChart'] = User::where('isAdmin', 0)->has('serviceCard')->where('created_at', '>=', now()->subMonth(48))->selectRaw('DATE_FORMAT(created_at,"%Y-%m-%d") as day,count(id) as user_count')->groupBy('day')->get();


        $data['users'] = User::where('isAdmin', 0)->count();
        $data['admins'] = User::where('isAdmin', 1)->count();
        $data['newUsers'] = User::where('isAdmin', 0)->where('created_at', '>=', now()->subDay(7))->count();
        $data['newAdmins'] = User::where('isAdmin', 1)->where('created_at', '>=', now()->subDay(7))->count();


        $data['serviceDepartment'] = serviceDepartment::count();
        $data['serviceCategory'] = serviceCategory::count();
        $data['serviceOffer'] = serviceOffer::count();
        $data['serviceCard'] = serviceCard::count();


        $data['ticketOpen'] = ticket::where('status','open')->count();
        $data['ticketClose'] = ticket::where('status','close')->count();
        $data['ticketPending'] = ticket::where('status','pending')->count();
        $data['ticketDeactive'] = ticket::where('status','deactive')->count();


        return view('admin.panel',$data);
    }
}
