<?php

namespace App\Http\Controllers\Admin\exportExcel;

use App\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements FromCollection,WithHeadings,WithMapping
{
    public function headings(): array
    {
        return [
            'شناسه',
            'ایمیل',
            'نام کاربری',
            'نام',
            'نام خانوادگی',
            'موبایل',
            'تلفن',
            'آدرس',
        ];
    }


    public function map($element): array
    {
        return [
            $element->id,
            $element->email,
            $element->userName,
            $element->firstName,
            $element->lastName,
            $element->mobile,
            $element->telephone,
            $element->address,
        ];
    }

    public function collection()
    {
        return User::select('id','email','userName','firstName','lastName','mobile','telephone','address')->search()->get();
    }
}
