<?php

namespace App\Http\Controllers\Admin\exportExcel;

use App\Models\Exam\exam;
use App\Models\Ticket\ticket;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class TicketExport implements FromCollection,WithHeadings,WithMapping
{
    public function headings(): array
    {
        return [
            'شناسه',
            'تیتر',
            'شناسه کاربر',
            'نام کاربر',
            'نام خانوادگی کاربر',
            'دپارتمان',
            'تعداد ارجاع',
            'وضعیت',
            'توضیحات',
            'تاریخ ایجاد'
        ];
    }


    public function map($element): array
    {
        $createdAt = toPersian($element->created_at);
        $user = $element->user;
        $referer = $element->referer()->count();

        $status = '';
        if ($status == 'urgent') {
            $status = 'فوری';
        } elseif ($status == 'high') {
            $status = 'بالا';
        } elseif ($status == 'medium') {
            $status = 'موتسط';
        } else {
            $status = 'پایین';
        }

        return [
            $element->id,
            $element->title,
            $element->user_id,
            $user->firstName,
            $user->lastName,
            $element->department->title,
            $referer,
            $status,
            $element->body,
            $createdAt,
        ];
    }


    public function collection()
    {
        return ticket::search()->get();
    }
}
