<?php

namespace App\Http\Controllers\Admin\Wallet;

use App\Http\Controllers\Controller;
use App\Models\Wallet\Wallet;
use App\Models\Wallet\walletRequest;
use App\User;
use Illuminate\Http\Request;

class walletRequestController extends Controller
{
    public function index()
    {
        $this->authorize('walletRequest_index');

        if (request()->has('page')) {
            $list = walletRequest::search()->with('wallet.model')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Wallet.request.index');
    }

    public function create()
    {
        $this->authorize('walletRequest_store');

        return view('admin.Wallet.request.create');
    }

    public function update($id, Request $request)
    {
        $this->authorize('walletRequest_store');

        $request->offsetSet('amount', str_replace(',', '', $request->input('amount')));
        $walletRequest = walletRequest::findOrFail($id);

        $this->validate($request, [
            'status' => 'required|in:agree,deny,pending'
        ]);


        $wallet = $walletRequest->wallet;
        if ($wallet->amount < $walletRequest->amount) {
            message('خطا','میزان اعتبار کیف پول کمتر از مقدار درخواستی میباشد','error');
            return redirect()->route('admin.wallet.request.index');
        }

        if ($request->input('status') == 'agree') {
            $walletRequest->update([
                'status' => $request->input('status')
            ]);
            $wallet->update([
                'amount' => $wallet->amount - $walletRequest->amount,
                'withdraw' => $wallet->withdraw + $walletRequest->amount
            ]);
        }


        message();
        return redirect()->route('admin.wallet.request.show',$walletRequest->id);
    }

    public function show(walletRequest $request)
    {
        $this->authorize('walletRequest_show');

        return view('admin.Wallet.request.show', compact('request'));
    }
}
