<?php

namespace App\Http\Controllers\Admin\Wallet;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Wallet\Wallet;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class walletController extends Controller
{
    public function index()
    {
        $this->authorize('wallet_index');

        if (request()->has('page')) {
            $list = Wallet::search()->with('model')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Wallet.wallet.index');
    }

    public function create()
    {
        $this->authorize('wallet_store');

        return view('admin.Wallet.wallet.create');
    }

    public function store(Request $request)
    {
        $this->authorize('wallet_store');

        $request->offsetSet('amount', str_replace(',', '', $request->input('amount')));

        $this->validate($request, [
            'user_id' => 'required|numeric|exists:users,id',
            'amount' => 'required|numeric|digits_between:1,12'
        ]);


        if (isset(User::where('id', $request->input('user_id'))->first()->wallet->id)) {
            message('خطا', 'برای کاربر انتخابی کیف پول ساخته شده است', 'error');
            return redirect()->route('admin.wallet.wallet.create');
        }


        $wallet = Wallet::create([
            'model_type' => 'App\User',
            'model_id' => $request->input('user_id'),
            'withdraw' => 0,
            'deposit' => $request->input('amount'),
            'amount' => $request->input('amount'),
            'status' => 1
        ]);


        $wallet->transaction()->create([
            'type' => 'manual',
            'amount' => $request->input('amount'),
            'body' => null,
            'editedBy' => auth()->user()->id . '-' . auth()->user()->firstName . '-' . auth()->user()->lastName,
            'status' => 1
        ]);

        message();
        return redirect()->route('admin.wallet.wallet.index');
    }

    public function show(Wallet $wallet)
    {
        $this->authorize('wallet_show');

        return view('admin.Wallet.wallet.show', compact('wallet'));
    }

}
