<?php

namespace App\Http\Controllers\Admin\Ticket;

use App\Http\Controllers\Controller;
use App\Models\Ticket\ticketDepartment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ticketDepartmentController extends Controller
{

    public function index()
    {
        $this->authorize('ticketDepartment_index');

        if (request()->has('page')) {
            $list = ticketDepartment::withCount('tickets')->search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Ticket.department.index');
    }

    public function create()
    {
        $this->authorize('ticketDepartment_store');

        return view('admin.Ticket.department.create');
    }

    public function store(Request $request)
    {
        $this->authorize('ticketDepartment_store');

        $this->validate($request, [
            'title'   => 'required|string|max:254',
            'order'   => 'required|numeric',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:2000',
        ]);

        $picture = getDefaultPhoto();
        if ($request->hasFile('picture')) {
            $picture = $request->file('picture')->store('uploads/ticket_departments');
        }

        ticketDepartment::create([
            'title'   => $request->input('title'),
            'order'   => $request->input('order'),
            'picture' => $picture,
            'status'  => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.ticketdepartment.index');
    }

    public function show(ticketDepartment $ticketdepartment)
    {
        $this->authorize('ticketDepartment_show');

        return redirect()->route($ticketdepartment);
    }

    public function edit(ticketDepartment $ticketdepartment)
    {
        $this->authorize('ticketDepartment_update');

        return view('admin.Ticket.department.edit',compact('ticketdepartment'));
    }

    public function update(Request $request, ticketDepartment $ticketdepartment)
    {
        $this->authorize('ticketDepartment_update');

        $this->validate($request, [
            'title'   => 'required|string|max:254',
            'order'   => 'required|numeric',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:2000',
        ]);

        if ($request->hasFile('picture')) {
            if ($ticketdepartment->picture !== getDefaultPhoto()) {
                Storage::delete($ticketdepartment->picture);
            }
            $ticketdepartment->picture = $request->file('picture')->store('uploads/ticket_departments');
        }

        $ticketdepartment->update([
            'title'   => $request->input('title'),
            'order'   => $request->input('order'),
            'picture' => $ticketdepartment->picture,
            'status'  => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.ticketdepartment.edit',$ticketdepartment->id);
    }

    public function destroy(ticketDepartment $ticketdepartment)
    {
        $this->authorize('ticketDepartment_destroy');

        if ($ticketdepartment->picture !== getDefaultPhoto()) {
            Storage::delete($ticketdepartment->picture);
        }

        return response()->json($ticketdepartment->delete());
    }

}
