<?php

namespace App\Http\Controllers\Admin\Ticket;

use App\Http\Controllers\Controller;
use App\Models\Ticket\ticket;
use App\Models\Ticket\ticketMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TicketMessageController extends Controller
{
    public function index()
    {
        $this->authorize('ticketMessage_index');

        if (request()->has('page')) {
            $list = auth()->user()->ticketReferer()->validate()->with('user','department')->withCount('messages')->search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Ticket.message.index');
    }

    public function indexMessage($id)
    {
        $ticket   = ticket::findOrFail($id);
        $messages = $ticket->messages()->with('user')->get();

        $ticketMessage = '';
        if (request()->has('message_id')) {
            $ticketMessage = $ticket->messages()->where('user_id', auth()->user()->id)->findOrFail(request()->input('message_id'));
        }

        return view('admin.Ticket.message.indexMessages',compact('ticket','messages','ticketMessage'));
    }

    public function store(Request $request)
    {
        $this->authorize('ticketMessage_store');

        $this->validate($request, [
            'ticket_id' => 'required|exists:tickets,id',
            'body'      => 'required|string',
            'type'      => 'required|in:all,note',
            'files.*'   => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:20000'
        ]);

        $ticket = ticket::findOrFail($request->input('ticket_id'));
        $message = $ticket->messages()->create([
            'user_id' => auth()->user()->id,
            'body'    => $request->input('body'),
            'type'    => $request->input('type')
        ]);

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $message->files()->create([
                    'path' => $file->store('uploads/ticket_files'),
                    'mime' => $file->getClientMimeType(),
                    'size' => $file->getClientSize()/1000,
                ]);
            }
        }

        message();
        return redirect()->route('admin.ticketmessages.indexMessage',$request->input('ticket_id'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('ticketMessage_update');

        $this->validate($request, [
            'body'      => 'required|string',
            'type'      => 'required|in:all,note',
            'files.*'   => 'nullable|mimes:jpeg,bmp,png,zip,rar,doc,docs,xls|max:20000'
        ]);

        $message = ticketMessage::where('user_id',auth()->user()->id)->findOrFail($id);
        $message->update([
            'body'    => $request->input('body'),
            'type'    => $request->input('type')
        ]);

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                $message->files()->create([
                    'path' => $file->store('uploads/ticket_files'),
                    'mime' => $file->getClientMimeType(),
                    'size' => $file->getClientSize()/1000,
                ]);
            }
        }

        message();
        return redirect()->route('admin.ticketmessages.indexMessage',$message->ticket_id);
    }

    public function destroy($id)
    {
        $this->authorize('ticketMessage_destroy');

        $message = ticketMessage::where('user_id', auth()->user()->id)->findOrFail($id);
        $files = $message->files()->get()->pluck('path')->toArray();
        $message->delete();
        Storage::delete($files);

        message('حذف شد.');
        return redirect()->route('admin.ticketmessages.indexMessage',$message->ticket_id);
    }
}
