<?php

namespace App\Http\Controllers\Admin\Skill;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Skill\skill;
use App\Models\Skill\skillCategory;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class skillCategoryController extends Controller
{
    public function index()
    {
        $this->authorize('skillCategory_index');

        if (request()->has('page')){
            $list = skillCategory::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Skil.category.index');
    }

    public function create()
    {
        $this->authorize('skillCategory_store');

        return view('admin.Skil.category.create');
    }

    public function store(Request $request)
    {
        $this->authorize('skillCategory_store');

        $this->validate($request, [
            'title' => 'required|string|max:255',
        ]);

        $skillCategory = skillCategory::create([
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);
        $skillCategory->skill()->sync(json_decode($request->input('skills_id')));


        message();
        return redirect()->route('admin.skill.category.index');
    }

    public function show(skillCategory $skill)
    {
        $this->authorize('skillCategory_show');

        return response()->json($skill);
    }

    public function edit($id)
    {
        $this->authorize('skillCategory_update');
        $skillCategory = skillCategory::findOrFail($id);

        return view('admin.Skil.category.edit', compact('skillCategory'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('skillCategory_update');
        $skillCategory = skillCategory::findOrFail($id);

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
            ],
        ]);

        $skillCategory->update([
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);
        $skillCategory->skill()->sync(json_decode($request->input('skills_id')));

        message('ویرایش شد.');
        return redirect()->route('admin.skill.category.edit', $skillCategory->id);
    }

    public function destroy($id)
    {
        $this->authorize('skillCategory_destroy');
        $serviceCard = skillCategory::findOrFail($id);

        return response()->json($serviceCard->delete());
    }

}
