<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Models\Setting\setting;
use App\Models\Setting\settingAdmin;
use App\Models\Setting\settingCategoryAdmin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    public function create()
    {
        $this->authorize('setting_index');
        $list = settingCategoryAdmin::where('type','default')->orderBy('order')->with('settingsAdmin.settings')->get();

        return view('admin.Setting.setting.create',compact('list'));
    }

    public function store(Request $request)
    {
        if ($request->has('string')) {
            foreach ($request->input('string') as $key => $item) {
                if ($item !== null) {
                    $insert = [];
                    foreach ($item as $itemKey => $itemValue) {
                        $insert[$itemKey] = $itemValue;
                    }
                    setting::updateOrCreate(
                        ['settingAdmin_id' => $key],
                        $insert
                    );
                }
            }
        }

        if ($request->has('textarea')) {
            foreach ($request->input('textarea') as $key => $item) {
                if ($item !== null) {
                    $insert = [];
                    foreach ($item as $itemKey => $itemValue) {
                        $insert[$itemKey] = $itemValue;
                    }
                    setting::updateOrCreate(
                        ['settingAdmin_id' => $key],
                        $insert
                    );
                }
            }
        }

        if ($request->has('editor')) {
            foreach ($request->input('editor') as $key => $item) {
                if ($item !== null) {
                    $insert = [];
                    foreach ($item as $itemKey => $itemValue) {
                        $insert[$itemKey] = $itemValue;
                    }
                    setting::updateOrCreate(
                        ['settingAdmin_id' => $key],
                        $insert
                    );
                }
            }
        }

        if ($request->has('boolean')) {
            foreach ($request->input('boolean') as $key => $item) {
                if ($item !== null) {
                    setting::updateOrCreate(
                        ['settingAdmin_id' => $key],
                        ['value'=> 1]
                    );
                }
            }
            $settingAdminIds = settingAdmin::where('type', 'boolean')->whereNotIn('id',array_keys($request->input('boolean')))->select('id')->get()->pluck('id');
            foreach ($settingAdminIds as $item) {
                setting::updateOrCreate(
                    ['settingAdmin_id' => $item],
                    ['value'=>0]
                );
            }
        }

        if ($request->has('article')) {
            foreach ($request->input('article') as $key => $item) {
                setting::updateOrCreate(
                    ['settingAdmin_id' => $key],
                    ['value'=> json_encode($item['value'])]
                );
            }
        }

        if ($request->has('product')) {
            foreach ($request->input('product') as $key => $item) {
                setting::updateOrCreate(
                    ['settingAdmin_id' => $key],
                    ['value'=> json_encode($item['value'])]
                );
            }
        }

        if (isset($request->allFiles()['files'])) {
            foreach ($request->allFiles()['files'] as $index => $file) {
                $setting = setting::where('settingAdmin_id',$index)->first();
                if (isset($setting->id)) {
                    Storage::delete($setting->value);
                    $setting->update(['value'=>$file->store('uploads/settings')]);
                }
                else{
                  setting::create([
                        'settingAdmin_id'=>$index,
                        'value'=>$file->store('uploads/settings')
                    ]);
                }
            }
        }

        setting::cache();
        message('Edited.');
        return redirect()->route('admin.settings.create');
    }
}
