<?php

namespace App\Http\Controllers\Admin\setting;

use App\Http\Controllers\Controller;
use App\Models\Setting\setting;
use App\Models\Setting\settingAdmin;
use App\Models\Setting\settingCategoryAdmin;
use Illuminate\Http\Request;

class SettingAdminController extends Controller
{
    public function index()
    {
        $this->authorize('setting_index');

        if (request()->has('page')){
            $list = settingAdmin::search()->with('category')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Setting.settingAdmin.index');
    }

    public function create()
    {
        $this->authorize('setting_store');

        $settingCat = settingCategoryAdmin::latest()->get()->pluck('title','id');

        return view('admin.Setting.settingAdmin.create',compact('settingCat'));
    }

    public function store(Request $request)
    {
        $this->authorize('setting_store');

        $this->validate($request, [
            'category_id'   => 'required|exists:setting_category_admins,id',
            'title'         => 'required|string|max:255',
            'name'          => 'required|string|max:255',
            'value'         => 'nullable|string|max:255',
            'type'          => 'required|in:string,file,boolean,article,product,textarea,editor,map'
        ]);

        settingAdmin::create([
            'category_id' => $request->input('category_id'),
            'title'       => $request->input('title'),
            'name'        => $request->input('name'),
            'value'       => $request->input('value',null),
            'type'        => $request->input('type'),
            'linkable'    => $request->has('linkable'),
            'status'      => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.setting.admin.store');
    }

    public function show(settingAdmin $admin)
    {
        $this->authorize('setting_show');

        return response()->json($admin);
    }

    public function edit(settingAdmin $admin)
    {
        $this->authorize('setting_update');

        $settingCat = settingCategoryAdmin::latest()->get()->pluck('title','id');

        return view('admin.Setting.settingAdmin.edit',compact('admin','settingCat'));
    }

    public function update(Request $request, settingAdmin $admin)
    {
        $this->authorize('setting_update');

        $this->validate($request, [
            'category_id'   => 'required|exists:setting_category_admins,id',
            'name'          => 'required|string|max:255',
            'value'         => 'nullable|string|max:255',
            'type'          => 'required|in:string,file,boolean,article,product,textarea,editor,map'
        ]);

        $admin->update([
            'category_id' => $request->input('category_id'),
            'title'       => $request->input('title'),
            'name'        => $request->input('name'),
            'value'       => $request->input('value',null),
            'type'        => $request->input('type'),
            'linkable'    => $request->has('linkable'),
            'status'      => $request->has('status'),
        ]);
        setting::cache();

        message();
        return redirect()->route('admin.setting.admin.edit', $admin->id);
    }

    public function destroy(settingAdmin $admin)
    {
        $this->authorize('setting_index');

        return response()->json($admin->delete());
    }
}
