<?php

namespace App\Http\Controllers\Admin\Service;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Service\serviceDepartment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class departmentController extends Controller
{
    public function index()
    {
        $this->authorize('serviceDepartment_index');

        if (request()->has('page')) {
            $list = serviceDepartment::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Service.department.index');
    }

    public function create()
    {
        $this->authorize('serviceDepartment_store');


        return view('admin.Service.department.create');
    }

    public function store(Request $request)
    {
        $this->authorize('serviceDepartment_store');


        $this->validate($request, [
            'title' => 'required|string|min:4|max:255',
            'logo' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $logo = null;
        if ($request->hasFile('logo')) {
            $logo = $request->file('logo')->store('uploads/service_departments');
        }

        $serviceDepartment = serviceDepartment::create([
            'title' => $request->input('title'),
            'logo' => $logo,
            'status' => $request->has('status')
        ]);
        $serviceDepartment->category()->attach(json_decode($request->input('category_id')));

        message();
        return redirect()->route('admin.service.department.index');
    }

    public function show(area $area)
    {
        $this->authorize('serviceDepartment_show');


        return response()->json($area);
    }

    public function edit($id)
    {
        $this->authorize('serviceDepartment_update');

        $serviceDepartment = serviceDepartment::findOrFail($id);

        return view('admin.Service.department.edit', compact('serviceDepartment'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('serviceDepartment_update');

        $serviceDepartment = serviceDepartment::findOrFail($id);

        $this->validate($request, [
            'title' => 'required|string|min:4|max:255',
            'logo' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $logo = $serviceDepartment->logo;
        if ($request->hasFile('logo')) {
            Storage::delete($serviceDepartment->logo);
            $logo = $request->file('logo')->store('uploads/service_departments');
        }

        $serviceDepartment->update([
            'title' => $request->input('title'),
            'logo' => $logo,
            'status' => $request->has('status')
        ]);
        $serviceDepartment->category()->sync(json_decode($request->input('category_id')));

        message('ویرایش شد.');
        return redirect()->route('admin.service.department.edit', $serviceDepartment->id);
    }

    public function destroy($id)
    {
        $this->authorize('serviceDepartment_destroy');

        $serviceDepartment = serviceDepartment::findOrFail($id);

        return response()->json($serviceDepartment->delete());
    }

}
