<?php

namespace App\Http\Controllers\Admin\Service;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Service\serviceCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class categoryController extends Controller
{
    public function index()
    {
        $this->authorize('serviceCategory_index');

        if (request()->has('page')) {
            $list = serviceCategory::search()->latest()->paginate();

            return response()->json($list);
        }

//        $result = curl_get_contents('http://www.application.mopon.ir/api/category/get');

//        return response()->json(json_decode($result));


        return view('admin.Service.category.index');
    }

    public function create()
    {
        $this->authorize('serviceCategory_store');


        return view('admin.Service.category.create');
    }

    public function store(Request $request)
    {
        $this->authorize('serviceCategory_store');

        $this->validate($request, [
            'title' => 'required|string|min:2|max:255',
            'body' => 'nullable|string',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $picture = null;
        if ($request->hasFile('picture')) {
            $picture = $request->file('picture')->store('uploads/service_categories');
        }

        $category = serviceCategory::create([
            'title' => $request->input('title'),
            'body' => $request->input('body'),
            'picture' => $picture,
            'status' => $request->has('status')
        ]);
        $category->department()->attach(json_decode($request->input('department_id')));

        message();
        return redirect()->route('admin.service.category.index');
    }

    public function show(area $area)
    {
        $this->authorize('serviceCategory_show');


        return response()->json($area);
    }

    public function edit($id)
    {
        $this->authorize('serviceCategory_update');

        $serviceCategory = serviceCategory::findOrFail($id);

        return view('admin.Service.category.edit', compact('serviceCategory'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('serviceCategory_update');

        $serviceCategory = serviceCategory::findOrFail($id);

        $this->validate($request, [
            'title' => 'required|string|min:2|max:255',
            'body' => 'nullable|string',
            'picture' => 'nullable|image|mimes:jpeg,bmp,png|max:4096',
        ]);

        $picture = $serviceCategory->picture;
        if ($request->hasFile('picture')) {
            Storage::delete($serviceCategory->picture);
            $picture = $request->file('picture')->store('uploads/service_categories');
        }

        $serviceCategory->update([
            'title' => $request->input('title'),
            'body' => $request->input('body'),
            'picture' => $picture,
            'status' => $request->has('status')
        ]);
        $serviceCategory->department()->sync(json_decode($request->input('department_id')));

        message('ویرایش شد.');
        return redirect()->route('admin.service.category.edit', $serviceCategory->id);
    }

    public function destroy($id)
    {
        $this->authorize('serviceCategory_destroy');

        $serviceCategory = serviceCategory::findOrFail($id);

        return response()->json($serviceCategory->delete());
    }

}
