<?php

namespace App\Http\Controllers\Admin\Service;

use App\Http\Controllers\Controller;
use App\Models\Service\serviceCardStatus;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class cardStatusController extends Controller
{
    public function index()
    {
        $this->authorize('serviceCardStatus_index');

        if (request()->has('page')){
            $list = serviceCardStatus::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Service.cardStatus.index');
    }

    public function create()
    {
        $this->authorize('serviceCardStatus_store');

        return view('admin.Service.cardStatus.create');
    }

    public function store(Request $request)
    {
        $this->authorize('serviceCardStatus_store');

        $this->validate($request, [
            'card_id' => 'required|numeric|exists:service_cards,id',
            'title' => 'required|string|max:255',
        ]);

        serviceCardStatus::create([
            'service_card_id' => $request->input('card_id'),
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);

        message();
        return redirect()->route('admin.service.cardstatus.index');
    }

    public function show(area $area)
    {
        $this->authorize('serviceCardStatus_show');

        return response()->json($area);
    }

    public function edit($id)
    {
        $this->authorize('serviceCardStatus_update');
        $serviceCardStatus = serviceCardStatus::findOrFail($id);

        return view('admin.Service.cardStatus.edit', compact('serviceCardStatus'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('serviceCardStatus_update');
        $serviceCardStatus = serviceCardStatus::findOrFail($id);

        $this->validate($request, [
            'card_id' => 'required|numeric|exists:service_cards,id',
            'title' => [
                'required',
                'string',
                'max:255',
            ],
        ]);

        $serviceCardStatus->update([
            'service_card_id' => $request->input('card_id'),
            'title' => $request->input('title'),
            'status' => $request->has('status')
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.service.cardstatus.edit', $serviceCardStatus->id);
    }

    public function destroy($id)
    {
        $this->authorize('serviceCardStatus_destroy');
        $serviceCardStatus = serviceCardStatus::findOrFail($id);

        return response()->json($serviceCardStatus->delete());
    }

}
