<?php

namespace App\Http\Controllers\Admin\Service;

use App\Http\Controllers\Controller;
use App\Models\Region\area;
use App\Models\Service\serviceCard;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class cardController extends Controller
{
    public function index()
    {
        $this->authorize('serviceCard_index');

        if (request()->has('page')){
            $list = serviceCard::search()->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Service.card.index');
    }

    public function create()
    {
        $this->authorize('serviceCard_store');

        return view('admin.Service.card.create');
    }

    public function store(Request $request)
    {
        $this->authorize('serviceCard_store');

        $request->offsetSet('price',str_replace(',','',$request->input('price')));

        $this->validate($request, [
            'title' => 'required|string|max:255|unique:service_cards,title',
            'price' => 'required|numeric|digits_between:3,12'
        ]);

        serviceCard::create([
            'title' => $request->input('title'),
            'price' => $request->input('price'),
            'status' => $request->has('status')
        ]);

        message();
        return redirect()->route('admin.service.card.index');
    }

    public function show(area $area)
    {
        $this->authorize('serviceCard_show');

        return response()->json($area);
    }

    public function edit($id)
    {
        $this->authorize('serviceCard_update');
        $serviceCard = serviceCard::findOrFail($id);

        return view('admin.Service.card.edit', compact('serviceCard'));
    }

    public function update(Request $request, $id)
    {
        $this->authorize('serviceCard_update');
        $serviceCard = serviceCard::findOrFail($id);

        $request->offsetSet('price',str_replace(',','',$request->input('price')));

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('service_cards')->ignore($serviceCard->id),
            ],
            'price' => 'required|numeric|digits_between:3,12'
        ]);

        $serviceCard->update([
            'title' => $request->input('title'),
            'price' => $request->input('price'),
            'status' => $request->has('status')
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.service.card.edit', $serviceCard->id);
    }

    public function destroy($id)
    {
        $this->authorize('serviceCard_destroy');
        $serviceCard = serviceCard::findOrFail($id);

        return response()->json($serviceCard->delete());
    }
}
