<?php

namespace App\Http\Controllers\Admin\Region;

use App\Http\Controllers\Controller;
use App\Models\Region\state;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class StateController extends Controller
{
    public function index()
    {
        $this->authorize('state_index');

        if (request()->has('page')){
            $list = state::search()->withCount('city')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Region.state.index');
    }

    public function create()
    {
        $this->authorize('state_store');

        return view('admin.Region.state.create');
    }

    public function store(Request $request)
    {
        $this->authorize('state_store');

        $this->validate($request, [
            'title'      => 'required|string|max:255|unique:states,title',
            'country_id' => 'required|exists:countries,id',
            'order'      => 'required|numeric',
        ]);

        state::create([
            'country_id' => $request->input('country_id'),
            'title'      => $request->input('title'),
            'latitude'   => $request->input('latitude'),
            'order'      => $request->input('order'),
            'status'     => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.region.state.index');
    }

    public function show(state $state)
    {
        $this->authorize('state_show');

        return response()->json($state);
    }

    public function edit(state $state)
    {
        $this->authorize('state_update');

        return view('admin.Region.state.edit',compact('state'));
    }

    public function update(Request $request, state $state)
    {
        $this->authorize('state_update');

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('states')->ignore($state->id),
            ],
            'country_id' => 'required|exists:countries,id',
            'order' => 'required|numeric',
        ]);

        $state->update([
            'country_id' => $request->input('country_id'),
            'title' => $request->input('title'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.region.state.edit',$state->id);
    }

    public function destroy(state $state)
    {
        $this->authorize('state_update');

        return response()->json($state->delete());
    }

}
