<?php

namespace App\Http\Controllers\Admin\Region;

use App\Http\Controllers\Controller;
use App\Models\Region\country;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CountryController extends Controller
{
    public function index()
    {
        $this->authorize('country_index');

        if (request()->has('page')){
            $list = country::search()->withCount('states')->latest()->paginate();

            return response()->json($list);
        }

        return view('admin.Region.country.index');
    }

    public function create()
    {
        $this->authorize('country_store');

        return view('admin.Region.country.create');
    }

    public function store(Request $request)
    {
        $this->authorize('country_store');

        $this->validate($request, [
            'title' => 'required|string|max:255|unique:countries,title',
            'code' => 'required|string|max:255|unique:countries,code',
            'order' => 'required|numeric',
        ]);

        country::create([
            'title' => $request->input('title'),
            'code' => $request->input('code'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message();
        return redirect()->route('admin.region.country.index');
    }

    public function show(country $country)
    {
        $this->authorize('countryte_show');

        return response()->json($country);
    }

    public function edit(country $country)
    {
        $this->authorize('country_update');

        return view('admin.Region.country.edit',compact('country'));
    }

    public function update(Request $request, country $country)
    {
        $this->authorize('country_update');

        $this->validate($request, [
            'title' => [
                'required',
                'string',
                'max:255',
                Rule::unique('countries')->ignore($country->id),
            ],
            'code' => [
                'required',
                'string',
                'max:255',
                Rule::unique('countries')->ignore($country->id),
            ],
            'order' => 'required|numeric',
        ]);

        $country->update([
            'title' => $request->input('title'),
            'code' => $request->input('code'),
            'latitude' => $request->input('latitude'),
            'order' => $request->input('order'),
            'status' => $request->has('status'),
        ]);

        message('ویرایش شد.');
        return redirect()->route('admin.region.country.edit',$country->id);
    }

    public function destroy(country $country)
    {
        $this->authorize('country_update');

        return response()->json($country->delete());
    }

}
